#!/usr/bin/perl

#
# cluster_initial_test.pl
#

use strict;
use warnings;

# use Fcntl;
use IO::Handle;
use IO::File;
use File::Sync qw(fsync);

my $NoOfFragmentLogFiles = 4;
my $FragmentLogFileSize = 1024*1024*256;

my $DataDir = ".";

# Create directory structure
$DataDir .= '/ndb_10_fs/DBLQH';
use File::Path;
mkpath([$DataDir . '/D8', $DataDir . '/D9', $DataDir . '/D10', $DataDir . '/D11']);

my $path;
my $buffer = ' ' x 32768;

for ( my $i = 0; $i < $NoOfFragmentLogFiles; $i++ ) {

  # Theoretically this should be done in 4 parallel threads!
  foreach ( ('/D8', '/D9', '/D10', '/D11') ) {

    $path = $DataDir . $_ . "/S" . $i . ".FragLog";
    print $path . "\n";

    # Write end
    sysopen(HANDLE, $path, O_RDWR|O_CREAT|O_EXCL) or die "sysopen $path: $!";
    sysseek(HANDLE, ($FragmentLogFileSize - 32768), SEEK_SET);
    syswrite(HANDLE, $buffer, 32768);
    fsync(HANDLE) or die "fsync: $!";

    # Write n x 1 Mbyte
    for ( my $n = 0 ; $n < ($FragmentLogFileSize / 1024 / 1024) ; $n++ ) {
      sysseek(HANDLE, $n*1024*1024, SEEK_SET);
      syswrite(HANDLE, $buffer, 32768);
      fsync(HANDLE) or die "fsync: $!";
    }
    close(HANDLE);
  }
}
exit(0);
