
-- csv_table.sql

-- Cleanup before beginning

warnings

system echo "Do cleanup ...";
DROP TABLE csv_test;
DROP TABLE inno_test;
DROP TABLE inno_test2;
system clear;
system echo;
system echo "CSV table demo";
system echo;
system echo "Press enter...";
system read;

-- Check version

system clear;
system echo;
system echo "SELECT version()";
system echo;
SELECT version();
system echo "Press enter...";
system read;

-- Show engines

system echo;
system echo "show engines";
system echo;
show engines;
system echo "Press enter...";
system read;

-- Create a CSV table

system clear;
system echo;
system echo "CREATE TABLE csv_test (id INT, value CHAR(20))";
system echo "ENGINE = CSV";
system echo;
CREATE TABLE csv_test (id INT, value CHAR(20))
ENGINE = CSV;

system echo "INSERT INTO csv_test";
system echo "VALUES (1, 'Record 1'), (2, 'Record 2'), (3, 'Record 3')";
system echo;
INSERT INTO csv_test
VALUES (1, 'Record 1'), (2, 'Record 2'), (3, 'Record 3');
system echo "SELECT * FROM csv_test";
system echo;
SELECT * FROM csv_test;
system echo "Press enter...";
system read;

-- Modify table

system clear;
system echo;
system echo "CVS table file looks like this:";
system echo;
system cat ${MYSQL_HOME}/data/test/csv_test.CSV;
system echo;
system echo "Do chmod for foreign access:";
system echo;
system echo "chmod o+r ${MYSQL_HOME}/data/test/csv_test.CSV";
system chmod o+r ${MYSQL_HOME}/data/test/csv_test.CSV;
system echo;
system echo "Now modify file with OpenOffice Calc:";
system echo;
system cat ${MYSQL_HOME}/data/test/csv_test.CSV | sed 's/^"//' | sed 's/",/,/' | sed 's/Record 3/by OO Calc/' >/tmp/cvs.tst;
system cat /tmp/cvs.tst >${MYSQL_HOME}/data/test/csv_test.CSV;
system cat ${MYSQL_HOME}/data/test/csv_test.CSV;
system echo;
system echo "Press enter...";
system read;
system echo "This would crash the MySQL Server!";
system echo "We have to fix it first:";
system echo;
system cat ${MYSQL_HOME}/data/test/csv_test.CSV | sed 's/^/"/' | sed 's/,/",/' >/tmp/cvs.tst;
system cat /tmp/cvs.tst >${MYSQL_HOME}/data/test/csv_test.CSV;
system cat ${MYSQL_HOME}/data/test/csv_test.CSV;
system echo;
system echo "Much better now but still does NOT yet work:";
system echo;
system echo "SELECT * FROM csv_test";
system echo;
SELECT * FROM csv_test;
system echo "Press enter...";
system read;
system clear;
system echo;
system echo "We forgot the";
system echo;
system echo "FLUSH TABLE csv_test";
system echo;
FLUSH TABLE csv_test;
system echo "Now it looks perfect:";
system echo;
SELECT * FROM csv_test;
system echo "Press enter...";
system read;

-- Change the table type

system clear;
system echo;
system echo "CREATE TABLE inno_test";
system echo "ENGINE = INNODB";
system echo "AS SELECT * FROM csv_test";
system echo;
CREATE TABLE inno_test
ENGINE = INNODB
AS SELECT * FROM csv_test;
system echo "OR ...";
system echo;
system echo "ALTER TABLE csv_test";
system echo "ENGINE = INNODB";
system echo;
ALTER TABLE csv_test
ENGINE = INNODB;
system echo "RENAME TABLE csv_test TO inno_test2";
system echo;
RENAME TABLE csv_test TO inno_test2;
system echo "And check:";
system echo;
system echo "SELECT table_name, engine table_rows";
system echo "  FROM information_schema.tables";
system echo " WHERE table_name LIKE '%test%'";
system echo;
SELECT table_name, engine table_rows
  FROM information_schema.tables
 WHERE table_name LIKE '%test%';
