#! /usr/bin/perl

# memuse.pl
# Kristian Koehntopp <7elhq3$ocs@valiant.koehntopp.de>

die "Usage: $0 PID\n" unless $ARGV[0] > 0;
$file = sprintf "/proc/%s/maps", $ARGV[0];
open IN, "<$file" or die;
while(<IN>) {
  ( $mem, $prot, $offset, $dev, $inode) = split;
  ( $start, $stop ) = split "-", $mem;
  $size = hex($stop) - hex($start);
  $total += $size;
  $able = " ";
  if ($prot =~ /^r-/ and $inode != 0) {
    $share += $size;
    $able = "s";
  }
#  printf "%12d %s %s", $size, $able, $_;
}
close IN;
printf "share   = %12d (%8.2f KB)\n", $share, $share/1024;
printf "private = %12d (%8.2f KB)\n", $total-$share, ($total-$share)/1024;
printf "total   = %12d (%8.2f KB) (%8.2f %% shareable)\n", $total, $total/1024, $share/$total*100

