#
# This is the well known SCOTT/tiger Schema from ORACLE ported to MySQL
#

# Start this script as --user root

warnings;

# Works also before 5.0.2
# Better use CREATE SCHEMA instead
CREATE DATABASE scott
;

use scott;

GRANT ALL PRIVILEGES ON scott.*
   TO 'scott'@'%'
IDENTIFIED BY 'tiger'
;

GRANT ALL PRIVILEGES ON scott.*
   TO 'scott'@'localhost'
IDENTIFIED BY 'tiger'
;

CREATE TABLE dept (
    deptno  INT          NOT NULL AUTO_INCREMENT
  , dname   VARCHAR(14)
  , loc     VARCHAR(13)
  , CONSTRAINT pk_dept PRIMARY KEY (deptno)
);

CREATE TABLE emp (
    empno     INT         NOT NULL AUTO_INCREMENT
  , ename     VARCHAR(10)
  , job       VARCHAR(9)
  , mgr       INT
  , hiredate  DATE
  , sal       FLOAT(7,2)
  , comm      FLOAT(7,2)
  , deptno    INT
  , CONSTRAINT pk_emp PRIMARY KEY (empno)
  , CONSTRAINT fk_deptno FOREIGN KEY (deptno)
    REFERENCES dept (deptno)
);

INSERT INTO dept VALUES (10, 'ACCOUNTING', 'NEW YORK');
INSERT INTO dept VALUES (20, 'RESEARCH', 'DALLAS');
INSERT INTO dept VALUES (30, 'SALES', 'CHICAGO');
INSERT INTO dept VALUES (40, 'OPERATIONS', 'BOSTON');

INSERT INTO emp VALUES (7369, 'SMITH', 'CLERK', 7902
  , str_to_date('17-12-1980', '%e-%c-%Y'), 800, NULL, 20);
INSERT INTO emp VALUES (7499, 'ALLEN', 'SALESMAN', 7698
  , str_to_date('20-2-1981', '%e-%c-%Y'), 1600, 300, 30);
INSERT INTO emp VALUES (7521, 'WARD', 'SALESMAN', 7698
  , str_to_date('22-2-1981', '%e-%c-%Y'), 1250, 500, 30);
INSERT INTO emp VALUES (7566, 'JONES', 'MANAGER', 7839
  , str_to_date('2-4-1981', '%e-%c-%Y'), 2975, NULL, 20);
INSERT INTO emp VALUES (7654, 'MARTIN', 'SALESMAN', 7698
  , str_to_date('28-9-1981', '%e-%c-%Y'), 1250, 1400, 30);
INSERT INTO emp VALUES (7698, 'BLAKE', 'MANAGER', 7839
  , str_to_date('1-5-1981', '%e-%c-%Y'), 2850, NULL, 30);
INSERT INTO emp VALUES (7782, 'CLARK', 'MANAGER', 7839
  , str_to_date('9-6-1981', '%e-%c-%Y'), 2450, NULL, 10);
INSERT INTO emp VALUES (7788, 'SCOTT', 'ANALYST', 7566
  , DATE_SUB(str_to_date('13-JUL-87', '%e-%b-%y'), INTERVAL 85 DAY)
  , 3000, NULL, 20);
INSERT INTO emp VALUES (7839, 'KING', 'PRESIDENT',NULL
  , str_to_date('17-11-1981', '%e-%c-%Y'), 5000, NULL, 10);
INSERT INTO emp VALUES (7844, 'TURNER', 'SALESMAN', 7698
  , str_to_date('8-9-1981', '%e-%c-%Y'), 1500, 0, 30);
INSERT INTO emp VALUES (7876, 'ADAMS', 'CLERK', 7788
  , DATE_SUB(str_to_date('13-JUL-87', '%e-%b-%y'), INTERVAL 51 DAY)
  , 1100, NULL, 20);
INSERT INTO emp VALUES (7900, 'JAMES', 'CLERK', 7698
  , str_to_date('3-12-1981', '%e-%c-%Y'), 950, NULL, 30);
INSERT INTO emp VALUES (7902, 'FORD', 'ANALYST', 7566
  , str_to_date('3-12-1981', '%e-%c-%Y'), 3000, NULL, 20);
INSERT INTO emp VALUES (7934, 'MILLER', 'CLERK', 7782
  , str_to_date('23-1-1982', '%e-%c-%Y'), 1300, NULL, 10);

CREATE TABLE bonus (
    ename  VARCHAR(10)
  , job    VARCHAR(9)
  , sal    FLOAT(7,2)
  , comm   FLOAT(7,2)
);

CREATE TABLE salgrade (
    grade  INT
  , losal  FLOAT(7,2)
  , hisal  FLOAT(7,2)
);

INSERT INTO salgrade VALUES (1,  700, 1200);
INSERT INTO salgrade VALUES (2, 1201, 1400);
INSERT INTO salgrade VALUES (3, 1401, 2000);
INSERT INTO salgrade VALUES (4, 2001, 3000);
INSERT INTO salgrade VALUES (5, 3001, 9999);
